"""BoreHoleManagerData Class."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
import copy

# 2. Third party modules

# 3. Aquaveo modules
from xms.FhwaVariable.core_data.calculator.calculator import Calculator

# 4. Local modules


class BoreHoleManagerCalc(Calculator):
    """Provides a class that will define a class that manages a list of gradation sets."""

    locations = ['Approach cross-section', 'Contraction cross-section',]

    def _get_can_compute(self):
        """Determine whether we have enough data to compute.

        Returns:
            can_compute (bool): True, if we can compute; otherwise, False
            message (str): message about why we can't compute
        """
        if self.get_data('Location')[1] == 'Approach cross-section':
            if self.input_dict['calc_data']['Approach locations'] == 'Single gradation for entire cross-section':
                approach_layer = self.get_data('Approach layer')[1]['calculator']
                can_compute, _ = approach_layer.get_can_compute_with_subdict(
                    self.input_dict, self.input_dict['calc_data']['Approach layer'])
                # if can_compute and approach_layer.d50 != 0.0:
                #     return True
            else:
                for set in [self.get_data('Left overbank layer')[1],
                            self.get_data('Approach layer')[1],
                            self.get_data('Right overbank layer')[1]]:
                    can_compute, _ = set['calculator'].get_can_compute()
                    set['calculator'].compute_data()
                    if not can_compute or set['calculator'].get_d50() == 0.0:
                        # can_compute_all = False
                        break
        else:
            for index in self.input_dict['calc_data']['Boreholes']:
                set = self.input_dict['calc_data']['Boreholes'][index]['calculator']
                can_compute, _ = set.get_can_compute()
                # if not can_compute:
                #     # can_compute_all = False
                #     break

        return True  # We want to always run the compute data routine

    def _compute_data(self):
        """Compute the data."""
        # TODO: Plot the cross-section and borehole cl
        if self.get_data('Location')[1] == 'Approach cross-section':
            self.results['Approach gradations'] = {}
            if self.input_dict['calc_data']['Approach locations'] == 'Single gradation for entire cross-section':
                approach_layer = self.get_data('Approach layer')[1]['calculator']
                self.results['Approach gradations']['Data complete'] = approach_layer.can_compute
            else:
                for set in [self.get_data('Left overbank layer')[1],
                            self.get_data('Approach layer')[1],
                            self.get_data('Right overbank layer')[1]]:
                    set['calculator'].compute_data()
                    data_complete = set['calculator'].get_d50() > 0.0
                    set_name = set['calculator'].input_dict['calc_data']['Name']
                    if set_name not in self.results['Approach gradations']:
                        self.results['Approach gradations'][set_name] = {}
                    self.results['Approach gradations'][set_name] = {}
                    self.results['Approach gradations'][set_name]['Data complete'] = data_complete
        else:
            self.results['Boreholes'] = {}
            can_compute_all = True
            for index in self.input_dict['calc_data']['Boreholes']:
                set = self.input_dict['calc_data']['Boreholes'][index]['calculator']
                can_compute, _ = set.get_can_compute()
                # if can_compute:
                set.compute_data_with_subdict(self.input_dict, self.input_dict['calc_data']['Boreholes'][index],
                                              self.plot_dict)
                # else:
                #     can_compute_all = False
                name = self.input_dict['calc_data']['Boreholes'][index]['Name']
                self.results['Boreholes'][name] = {}
                self.results['Boreholes'][name]['Number of layers'] = len(self.input_dict['calc_data']['Boreholes'][
                    index]['Layers'])
                self.results['Boreholes'][name]['Data complete'] = can_compute

            self.results['Boreholes']['Number of boreholes'] = len(self.input_dict['calc_data']['Boreholes'])
            self.results['Boreholes']['Data complete'] = can_compute_all

        # Plot Borehole Centerlines
        # TODO: Fix plotting
        if 'Borehole centerlines' in self.plot_dict:
            bh_plot_dict = self.plot_dict['Borehole centerlines']
            borehole_names = []
            borehole_cl = []

            for bh_index in self.input_dict['calc_data']['Boreholes']:
                bh = self.input_dict['calc_data']['Boreholes'][bh_index]
                borehole_names.append(bh['Name'])
                borehole_cl.append(bh['Centerline'])
            bh_plot_index = next(iter(bh_plot_dict['lines']))
            bh_plot_dict = bh_plot_dict['lines'][bh_plot_index]
            if bh_plot_dict is not None:
                if self.bcs_plot_dict is not None and self.bcs_plot_dict['x var'] is not None:
                    bh_plot_dict['native unit'] = self.bcs_plot_dict['x var'].native_unit
                    bh_plot_dict['selected_us_unit'] = self.bcs_plot_dict['x var'].selected_us_unit
                    bh_plot_dict['selected_si_unit'] = self.bcs_plot_dict['x var'].selected_si_unit
                bh_plot_dict['Labels'] = borehole_names
                bh_plot_dict['Line intercepts'] = borehole_cl

            cs_plot_subdict, cs_plot_index = self.get_plot_subdict_and_key_by_name('Bridge cross-section', 'series',
                                                                                   'Borehole centerlines')
            if cs_plot_subdict is not None and self.bcs_plot_dict is not None:
                self.plot_dict['Borehole centerlines']['series'][cs_plot_index] = copy.deepcopy(self.bcs_plot_dict)

            piers_plot_subdict, piers_plot_index = self.get_plot_subdict_and_key_by_name('Piers', 'series',
                                                                                         'Borehole centerlines')
            if piers_plot_subdict is not None and self.pier_data is not None:
                self.plot_dict['Borehole centerlines']['series'][piers_plot_index] = copy.deepcopy(self.pier_data)

            abut_plot_subdict, abut_plot_index = self.get_plot_subdict_and_key_by_name('Abutment toe', 'lines',
                                                                                       'Borehole centerlines')
            if abut_plot_subdict is not None and self.abutment_data is not None:
                self.plot_dict['Borehole centerlines']['lines'][abut_plot_index] = copy.deepcopy(self.abutment_data)

        return True
