"""This module includes helper functions for dealing with param."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def names_and_params_from_class(param_cls):
    """Returns a list of param names and objects.

    Args:
        param_cls (param.Parameterized): class with param objects

    Return:
        names(list(str)), params(list(param objects)
    """
    names = []
    params = []
    p = param_cls.param
    for item in p.objects().items():
        if item[0] in ['name']:
            continue
        obj = getattr(p, item[0])
        if obj is not None:
            names.append(item[0])
            params.append(obj)
    return names, params


def declared_precedence_dict(param_cls):
    """Returns a dict where [param_name] = param_precedence.

    Args:
        param_cls (param.Parameterized): class with param objects

    Return:
        precedence(dict[str] = float)
    """
    class_objs = param_cls.param.objects(instance=False)
    precedence = dict()
    for key, val in class_objs.items():
        if key == 'name':
            continue
        precedence[key] = val.precedence
    return precedence
