"""Python wrapping for xms.api._xmsapi.dmi.MenuItem."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import MenuItem as CMenuItem
from xms.api.dmi import ActionRequest


class MenuItem:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.MenuItem objects."""
    def __init__(self, text=None, action=None, icon_path=None, enabled=None, instance=None):
        """Construct the wrapper.

        Args:
            text (str): The text that will appear in the right-click menu of the parent object for this item
            action (ActionRequest): The ActionRequest associated with this menu item
            icon_path (str): Path to the menu item's icon image. Must be an image that can be imported into the Qt
                GUI environment.
            enabled (bool): True if the menu item should be enabled
            instance (CMenuItem): The C++ MenuItem object to wrap
        """
        if instance is None:
            self._instance = CMenuItem()
        else:
            self._instance = instance

        if text is not None:
            self._instance.SetText(text)
        if action is not None:
            self.action_request = action  # Property setter will unwrap
        if icon_path is not None:
            self._instance.SetIcon(icon_path)
        if enabled is not None:
            self._instance.SetEnabled(enabled)

    @property
    def action_request(self):
        """Returns the ActionRequest that will be executed when this MenuItem is clicked."""
        return ActionRequest(instance=self._instance.GetActionRequest())

    @action_request.setter
    def action_request(self, action):
        """Sets the ActionRequest that will be executed when this MenuItem is clicked.

        Args:
            action (ActionRequest): The ActionRequest associated with this menu item
        """
        self._instance.SetActionRequest(action._instance)

    @property
    def enabled(self):
        """Returns False if the menu item should be disabled."""
        return self._instance.GetEnabled()

    @enabled.setter
    def enabled(self, enable_menu):
        """Sets the flag to indicate whether the menu item is enabled or not.

        Args:
            enable_menu (bool): True if the menu item should be enabled
        """
        self._instance.SetEnabled(enable_menu)

    @property
    def icon(self):
        """Returns the filesystem path to the icon file associated with the menu item."""
        return self._instance.GetIcon()

    @icon.setter
    def icon(self, icon_path):
        """Sets the filesystem path to the icon file associated with the menu item.

        Args:
            icon_path (str): Path to the menu item's icon image. Must be an image that can be imported into the Qt
                GUI environment.
        """
        self._instance.SetIcon(icon_path)

    @property
    def text(self):
        """Returns the GUI text that appears with this menu item."""
        return self._instance.GetText()

    @text.setter
    def text(self, menu_text):
        """Sets the GUI text that appears with this menu item.

        Args:
            menu_text (str): The text that will appear in the right-click menu of the parent object for this item
        """
        self._instance.SetText(menu_text)
