"""Python wrapping for xms.api._xmsapi.dmi.MetaDataRequest."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import MetaDataRequest as CMetaDataRequest
from xms.api.dmi.RequestBase import RequestBase
from xms.api.dmi import OrderBy, FilterBy


class MetaDataRequest(RequestBase):
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.MetaDataRequest objects."""
    def __init__(self, instance=None):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.MetaDataRequest): The C++ object to wrap
        """
        if instance is None:
            instance = CMetaDataRequest()
        super().__init__(instance)

    @property
    def order(self):
        """Returns the OrderBy constraint of the MetaDataRequest."""
        return OrderBy(instance=self._instance.GetOrder())

    @order.setter
    def order(self, order_by):
        """Sets the OrderBy constraint of the MetaDataRequest.

        Args:
            order_by (xms.api.dmi.OrderBy): The OrderBy restriction to use with the MetaDataRequest
        """
        self._instance.SetOrder(order_by._instance)

    @property
    def filter(self):
        """Returns the FilterBy constraint of the MetaDataRequest."""
        return FilterBy(instance=self._instance.GetFilter())

    @filter.setter
    def filter(self, filter_by):
        """Sets the FilterBy constraint of the MetaDataRequest.

        Args:
            filter_by (xms.api.dmi.FilterBy): The FilterBy restriction to use with the MetaDataRequest
        """
        self._instance.SetFilter(filter_by._instance)
