"""Python wrapping for xms.api._xmsapi.dmi.Session."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import Session as CSession
from xms.api.dmi import Context as PyContext
from xms.api.dmi import ProgressLoop as PyProgressLoop


class Session:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.Session objects."""
    def __init__(self, instance=None):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.Session): The C++ object to wrap
        """
        if instance is None:
            self._instance = CSession()
        else:
            self._instance = instance

    @property
    def process_id(self):
        """Returns the XMS-internal PID (not the OS PID) of the Python process owning the Session."""
        return self._instance.GetProcessID()

    @property
    def context(self):
        """Returns the xms.api.dmi.Context associated with the Session."""
        return PyContext(instance=self._instance.GetContext())

    @property
    def context_definition(self):
        """Returns the xms.api._xmsapi.dmi.ContextDefinition associated with the Session."""
        return self._instance.GetContextDefinition()

    @property
    def progress_loop(self):
        """Returns the xms.api.dmi.ProgressLoop associated with the Session.

        Note only applicable if process is a progress script.
        """
        return PyProgressLoop(instance=self._instance.GetProgressLoop())

    @property
    def read_file(self):
        """Returns the filesystem path to the file being imported by the process.

        Note only applicable if process is an import script.
        """
        return self._instance.GetReadFile()
