"""This is a dialog for specifying advanced cards that are not currently supported in the interface."""

__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import QHBoxLayout, QLabel, QLineEdit

# 3. Aquaveo modules
from xms.guipy.dialogs.treeitem_selector_datasets import TreeItemSelectorDatasetsDlg
from xms.guipy.validators.qx_double_validator import QxDoubleValidator

# 4. Local modules


class ArcAtContourDlg(TreeItemSelectorDatasetsDlg):
    """A dialog for selecting the dataset and value to create an arc at."""
    def __init__(self, pe_tree, query, parent=None):
        """Initializes the class, sets up the ui.

        Args:
            parent (Something derived from :obj:`QWidget`): The parent window.
            pe_tree (TreeNode): Project explorer dump from Query at root.
            query (:obj:`xmsapi.dmi.Query`): Object for communicating with SMS.
        """
        super().__init__('Select Contour Options', pe_tree, query=query, parent=parent)
        self._dlg_name = 'xms.cmsflow.gui.arc_at_contour_dlg'
        self.help_url = 'https://www.xmswiki.com/wiki/SMS:CMS-Flow'

        value_layout = QHBoxLayout()
        self.value_label = QLabel()
        self.value_edit = QLineEdit()
        self.dbl_valid = QxDoubleValidator(parent=self)
        self.dbl_valid.setDecimals(10)

        self.value_label.setText('Contour value:')

        self.value_edit.setText('0.0')
        self.value_edit.setValidator(self.dbl_valid)

        value_layout.addWidget(self.value_label)
        value_layout.addWidget(self.value_edit)
        value_layout.addStretch()
        self.ui.verticalLayout.insertLayout(self.ui.verticalLayout.count() - 2, value_layout)
