"""Base class for XMS DMI migration components."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query

# 4. Local modules


class MigrateBase:
    """Base class for XMS DMI migration components."""
    def __init__(self):
        """Construct the migrate base."""
        pass

    def map_to_typename(
        self, uuid_map: dict, widget_map: dict, take_map: dict, main_file_map: dict, hidden_component_map: dict,
        material_atts: dict, material_polys: dict, query: Query
    ):
        """This is the first pass of a two-pass system.

        This function performs all the data object migrations necessary for use between versions of model interfaces.

        Args:
            uuid_map: This is a map from uuid's to object attributes. This is a collection of things you want to find
             the conversions for.
            widget_map: This is a larger dictionary mapping uuid's to their conversions.
            take_map: This is a map from uuid's of taking objects to a list of uuids of objects taken by the taker.
            main_file_map: This is a map from uuid's to main files of components.
            hidden_component_map: This is a map from uuid's of owning objects to a list of uuids of hidden components
             owned by the object.
            material_atts: Dictionary whose key is coverage UUID and value is dict whose key is material id and value
             is tuple of display options (name, r, g, b, alpha, texture)
            material_polys: Dictionary whose key is coverage UUID and value is dict whose key is material id and value
             is a set of polygon ids with that material assignment.
            query: This is used to communicate with XMS. Do not call the 'send' method on this instance as 'send' will
             be called later.

        Returns:
            (dict): This is the map of delete and replacement requests.
        """
        return {}

    def send_replace_map(self, replace_map: dict, query: Query):
        """This is the second pass of a two-pass system.

        Args:
            replace_map: This is the map of delete and replace requests. This can be generated by map_to_typename().
            query: This is used to communicate with SMS.
        """
        pass

    def get_messages_and_actions(self):
        """Called at the end of migration.

        This is for when a message needs to be given to the user about some change due to migration.
        Also, an ActionRequest can be given if there is ambiguity in the migration.

        Returns:
            (list of tuple of str, list of xms.api.dmi.ActionRequest):
                messages, action_requests - Where messages is a list of tuples with the first element of the tuple being
                the message level (DEBUG, ERROR, WARNING, INFO) and the second element being the message text.
                action_requests is a list of actions for XMS to perform.
        """
        return [], []
