from . import GridType
from . import _xmsconstraint
from .ugrid_2d import UGrid2d
from .ugrid_3d import UGrid3d
from .unconstrained_grid import UnconstrainedGrid


class UGridBuilder:
    """Builder for a 2D, 3D, or unconstrained UGrid."""

    def __init__(self):
        self._instance = _xmsconstraint.constraint.CoUGridBuilder()

    def set_unconstrained(self):
        """Set result type as an unconstrained UGrid."""
        self._instance.SetUnconstrained()

    def set_is_2d(self):
        """Set result type as a 2D UGrid."""
        self._instance.SetIs2d()

    def set_is_3d(self):
        """Set result type as a 3D UGrid."""
        self._instance.SetIs3d()

    def set_ugrid(self, ugrid):
        """
        Set the UGrid of the constraint.
        Args:
            ugrid: The UGrid.
        """
        self._instance.SetXmUGrid(ugrid._instance)

    def build_grid(self):
        """
        Build and return the constrained UGrid.
        Returns:
            The constrained UGrid.
        """
        grid = self._instance.BuildGrid()
        if not grid:
            raise ValueError('Unable to build constrained grid.')
        if grid.GetGridType() == GridType.ugrid_2d:
            return UGrid2d(instance=grid)
        elif grid.GetGridType() == GridType.ugrid_3d:
            return UGrid3d(instance=grid)
        elif grid.GetGridType() == GridType.unconstrained:
            return UnconstrainedGrid(instance=grid)
        raise ValueError('Unable to build constrained grid.')
