"""Runs the model control dialog."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.gui.group_set_dialog import GroupSetDialog

# 4. Local modules
from xms.cstorm.dmi.xms_data import XmsData

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"


def model_control_dialog(sim, query, parent):
    """Runs the model control.

    Args:
        sim (:obj:`SimulationComponent`): The simulation
        query (:obj:`Query`): Object for communicating with XMS
        parent (:obj:`QWidget`): The window container.
    """
    runner = ModelControlDialogRunner(sim, query, parent)
    runner.run_dialog()


class ModelControlDialogRunner:
    """Runs the model control dialog."""
    def __init__(self, sim, query, parent):
        """Initializes the class.

        Args:
            sim (:obj:`SimulationComponent`): The simulation
            query (:obj:`Query`): Object for communicating with XMS
            parent (:obj:`QWidget`): The window container.
        """
        self.sim = sim
        self.query = query
        self.parent = parent
        self.xms_data = XmsData(query, at_sim=False)
        self.gm = None
        self.grp = None

    def run_dialog(self):
        """Runs the dialog."""
        self._setup_generic_model()
        dlg_name = 'xms.cstorm.sim_component.model_control'
        dlg = GroupSetDialog(
            parent=self.parent,
            section=self.gm.global_parameters,
            get_curve=None,
            add_curve=None,
            is_interior=False,
            window_title='CSTORM Model Control',
            dlg_name=dlg_name,
            multi_select_message='',
            show_groups=False
        )
        if dlg.exec():
            self._dialog_ok()

    def _dialog_ok(self):
        """Saves data from the dialog."""
        self.sim.data.info.attrs['OPTIONS'] = self.gm.global_parameters.extract_values()
        self.sim.data.commit()

    def _setup_generic_model(self):
        """Sets up the generic model class for the GroupSet dialog."""
        self.gm = self.sim.data.generic_model
        self.grp = self.gm.global_parameters.group('model_control')
