"""Xarray data class for the EWN Feature coverage component."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

UNINITIALIZED_COMP_ID = -1

FEATURE_TYPE_UNASSIGNED = 0
FEATURE_TYPE_MESH_TRANSITION = 1
FEATURE_TYPE_ADCIRC_LEVEE = 2
EWN_POLYGON_FEATURE_TYPES = {
    FEATURE_TYPE_UNASSIGNED: 'Unassigned',
}

ELEVATION_METHOD_CONSTANT = 0
ELEVATION_METHOD_Z_OFFSET = 1
EWN_ELEVATION_METHOD = {
    ELEVATION_METHOD_CONSTANT: 'Constant',
    ELEVATION_METHOD_Z_OFFSET: 'Z offset',
}

TRANSITION_METHOD_FACTOR = 0
TRANSITION_METHOD_DISTANCE = 1
TRANSITION_METHOD_POLYGON = 2
EWN_TRANSITION_METHOD = {
    TRANSITION_METHOD_FACTOR: 'Bounding box factor',
    TRANSITION_METHOD_DISTANCE: 'Specified distance',
    TRANSITION_METHOD_POLYGON: 'Transition polygon',
}

SEDIMENT_TYPE_NONE = 0
SEDIMENT_TYPE_SPECIFY_CUT = 1
SEDIMENT_TYPE_SPECIFY_FILL = 2
SEDIMENT_TYPE_AVAILABLE_CUT = 3
SEDIMENT_TYPE_AVAILABLE_FILL = 4
EWN_POLYGON_SEDIMENT_TYPES = {
    SEDIMENT_TYPE_NONE: 'None',
    SEDIMENT_TYPE_SPECIFY_CUT: 'Specified cut region',
    SEDIMENT_TYPE_SPECIFY_FILL: 'Specified fill region',
    SEDIMENT_TYPE_AVAILABLE_CUT: 'Available cut region',
    SEDIMENT_TYPE_AVAILABLE_FILL: 'Available fill region',
}

CUT_FILL_TYPE_CONSTANT = 0
CUT_FILL_TYPE_REL_THICK = 1
CUT_FILL_TYPE_TOTAL_VOL_ELEV = 2
CUT_FILL_TYPE_TOTAL_VOL_THICK = 3
EWN_CUT_FILL_TYPE = {
    CUT_FILL_TYPE_CONSTANT: 'Constant elevation',
    CUT_FILL_TYPE_REL_THICK: 'Relative thickness',
    CUT_FILL_TYPE_TOTAL_VOL_ELEV: 'Total volume by elevation',
    CUT_FILL_TYPE_TOTAL_VOL_THICK: 'Total volume by thickness',
}

# Columns in the dredge computation table
COL_POLY_NAME = 0
COL_SEDIMENT_TYPE = 1
COL_PRIORITY = 2
COL_PRIORITY_PERCENT = 3
COL_CUT_FILL_TYPE = 4
COL_VOLUME_VALUE = 5
COL_TOTAL_VOLUME = 6
COL_REQUIRED_VOLUME = 7
COL_AVAILABLE_VOLUME = 8
COL_CUT_VOLUME = 9
COL_FILL_VOLUME = 10

DEFAULT_MATERIAL_COLORS = [
    (255, 0, 0),  # red
    (0, 0, 255),  # blue
    (0, 255, 51),  # green
    (255, 204, 0),  # yellow
    (0, 204, 255),  # cyan
    (255, 0, 204),  # magenta
    (153, 0, 255),  # purple
    (255, 102, 0),  # orange
    (51, 153, 51),  # dark green
    (153, 102, 0),  # brown
    (102, 153, 153),  # grey blue
    (153, 51, 51),  # dark red
    (255, 153, 255),  # light magenta
]
