"""SMS entry point for the simulation import script."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 4. Local modules
from xms.funwave.feedback.simulation_import_runner import import_simulation_with_feedback


def main():
    """Entry point wrapper."""
    try:
        import_simulation_with_feedback(single_sim=True)
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":
    main()
