"""A QLayout for param objects."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"


class ParamLayout:
    """Extra options for param classes when rendered by PySide2."""
    def __init__(
        self,
        horizontal_layout='',  # widget is part of a horizontal layout
        size_policy_min=False,  # set widget height
        group_id=None,  # identifier for a group
        group_label=None,  # creates a group and places the label
        dataset_selector_action=None,  # handler for button click on dataset selector
        xy_series_action=None,  # is the data frame an xy series
        string_is_label=False,  # option to display param.String as label instead of edit field
        multiline_edit=False,  # option to display param.String as a multi-line edit field
        tab_changes_focus=False,  # if multiline_edit, tab key changes focus instead of inserting a tab
        string_is_file_selector=True,  # replace Param.FileSelector with Param.String
        dataframe_rows_spin_box=True,  # display the number of rows spinbox with param.DataFrame
        show_string=True,  # show the string with param.String
    ):
        """Initializes the data class."""
        self.dataset_selector_action = dataset_selector_action
        self.horizontal_layout = horizontal_layout
        self.size_policy_min = size_policy_min
        self.group_id = group_id
        self.group_label = group_label
        self.xy_series_action = xy_series_action
        self.string_is_label = string_is_label
        self.multiline_edit = multiline_edit
        self.tab_changes_focus = tab_changes_focus
        self.string_is_file_selector = string_is_file_selector
        self.dataframe_rows_spin_box = dataframe_rows_spin_box
        self.show_string = show_string

    def dataset_selector_action(self):
        """Empty dataset.selector functionality."""
        pass
