"""QGroupBox that can collapse and expand."""

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import QGroupBox

# 3. Aquaveo modules

# 4. Local modules


class CollapsibleGroupBox(QGroupBox):
    """Groupbox that collapses on checkbox toggle.

    Adapted from: https://gist.github.com/JokerMartini/a4bd6c3df8283e22cc09
    """
    def __init__(self, parent=None):
        """Construct the collapsible groupbox.

        Args:
            parent (QObject): Parent of the groupbox
        """
        super().__init__(parent)
        self.setCheckable(True)
        fixed_height = max(self.sizeHint().height(), 30)
        self.setFixedHeight(fixed_height)
        self.toggled.connect(self.toggle_group)

    def toggle_group(self):
        """Slot to handle when user expands or collapses the groupbox."""
        state = self.isChecked()
        if state:
            fixed_height = max(self.sizeHint().height(), 30)
            self.setFixedHeight(fixed_height)
        else:
            self.setFixedHeight(30)
