"""OptionsBlock class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class OptionsBlock:
    """Class to handle an OPTIONS block."""
    def __init__(self, definitions):
        """Initializes the class.

        Args:
            definitions (list): Definition of all available options.
        """
        self.definitions = definitions
        self.options = {}  # The actual, existing options

    def dict(self):
        """Returns the options as a dict.

        Returns:
            (dict[str, value]): See description.
        """
        return self.options

    def defined(self, option):
        """Returns True if option is in the list of the defined options, whether it's currently on/included or not.

        Args:
            option (str): Name of the option (e.g. 'BOUNDNAMES').

        Returns:
            (bool): See description.
        """
        for definition in self.definitions:
            if definition.option == option:
                return True
        return False

    def has(self, key):
        """Returns true if the key exists in the options.

        Args:
            key (str): The option.

        Returns:
            (bool): See description.
        """
        return key in self.options

    def set(self, key, on, value):
        """Sets an option (a dict entry from an options block).

        Args:
            key (str): The key.
            on (bool): True to add or set it, False to remove it.
            value (any): The value to associate with the key. Can be str, list, None etc.
        """
        if on:
            # if value is not None:
            #     self.options[key] = value
            # else:
            #     self.options[key] = None
            self.options[key] = value
        else:
            self.options.pop(key, None)

    def get(self, key, default=None):
        """Returns the option's first value in the list.

        Args:
            key (str): The option key.
            default: The default value.

        Returns:
            The first value in the list of values for the option.
        """
        return self.options.get(key, default)
