"""Data utility functions."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.ats_data import AtsData
from xms.mf6.data.dis_data import DisData
from xms.mf6.data.disu_data import DisuData
from xms.mf6.data.disv_data import DisvData
from xms.mf6.data.ems_data import EmsData
from xms.mf6.data.exchanges.gwe_gwe_data import GweGweData
from xms.mf6.data.exchanges.gwf_gwe_data import GwfGweData
from xms.mf6.data.exchanges.gwf_gwf_data import GwfGwfData
from xms.mf6.data.exchanges.gwf_gwt_data import GwfGwtData
from xms.mf6.data.exchanges.gwf_prt_data import GwfPrtData
from xms.mf6.data.exchanges.gwt_gwt_data import GwtGwtData
from xms.mf6.data.gwe.cnd_data import CndData
from xms.mf6.data.gwe.ctp_data import CtpData
from xms.mf6.data.gwe.esl_data import EslData
from xms.mf6.data.gwe.est_data import EstData
from xms.mf6.data.gwe.gwe_data import GweData
from xms.mf6.data.gwe.lke_data import LkeData
from xms.mf6.data.gwe.mve_data import MveData
from xms.mf6.data.gwe.mwe_data import MweData
from xms.mf6.data.gwe.sfe_data import SfeData
from xms.mf6.data.gwe.uze_data import UzeData
from xms.mf6.data.gwf.buy_data import BuyData
from xms.mf6.data.gwf.chd_data import ChdData
from xms.mf6.data.gwf.csub_data import CsubData
from xms.mf6.data.gwf.drn_data import DrnData
from xms.mf6.data.gwf.evt_array_data import EvtArrayData
from xms.mf6.data.gwf.evt_list_data import EvtListData
from xms.mf6.data.gwf.ghb_data import GhbData
from xms.mf6.data.gwf.gnc_data import GncData
from xms.mf6.data.gwf.gwf_data import GwfData
from xms.mf6.data.gwf.hfb_data import HfbData
from xms.mf6.data.gwf.lak_data import LakData
from xms.mf6.data.gwf.maw_data import MawData
from xms.mf6.data.gwf.mvr_data import MvrData
from xms.mf6.data.gwf.npf_data import NpfData
from xms.mf6.data.gwf.rch_array_data import RchArrayData
from xms.mf6.data.gwf.rch_list_data import RchListData
from xms.mf6.data.gwf.riv_data import RivData
from xms.mf6.data.gwf.sfr_data import SfrData
from xms.mf6.data.gwf.sto_data import StoData
from xms.mf6.data.gwf.swi_data import SwiData
from xms.mf6.data.gwf.tab_data import TabData
from xms.mf6.data.gwf.uzf_data import UzfData
from xms.mf6.data.gwf.vsc_data import VscData
from xms.mf6.data.gwf.wel_data import WelData
from xms.mf6.data.gwf.zone_data import ZoneData
from xms.mf6.data.gwt.adv_data import AdvData
from xms.mf6.data.gwt.cnc_data import CncData
from xms.mf6.data.gwt.dsp_data import DspData
from xms.mf6.data.gwt.fmi_data import FmiData
from xms.mf6.data.gwt.gwt_data import GwtData
from xms.mf6.data.gwt.ist_data import IstData
from xms.mf6.data.gwt.lkt_data import LktData
from xms.mf6.data.gwt.mdt_data import MdtData
from xms.mf6.data.gwt.mst_data import MstData
from xms.mf6.data.gwt.mvt_data import MvtData
from xms.mf6.data.gwt.mwt_data import MwtData
from xms.mf6.data.gwt.sft_data import SftData
from xms.mf6.data.gwt.ssm_data import SsmData
from xms.mf6.data.gwt.uzt_data import UztData
from xms.mf6.data.ic_data import IcData
from xms.mf6.data.ims_data import ImsData
from xms.mf6.data.mfsim_data import MfsimData
from xms.mf6.data.obs_data import ObsData
from xms.mf6.data.oc_data import OcData
from xms.mf6.data.pest_obs_data import PestObsData
from xms.mf6.data.src_data import SrcData
from xms.mf6.data.tdis_data import TdisData
from xms.mf6.data.time_array_series_data import TimeArraySeriesData
from xms.mf6.data.time_series_data import TimeSeriesData
from xms.mf6.data.tva_data import TvaData


def package_from_ftype(ftype, **kwargs):
    """Returns the default package object corresponding to the ftype.

    Args:
        ftype (str): The file type used in the GWF name file (e.g. 'WEL6')
        **kwargs: Arbitrary keyword arguments.

    Keyword Args:
        mfsim (MfsimData): The simulation.
        model (GwfData or GwtData): The GWF model. Will be None for TDIS, IMS, Exchanges (things below mfsim)
        grid_info (GridInfo): Information about the grid. Only used when testing individual packages. Otherwise,
         it comes from model and dis

    Returns:
        The package data class which should be something derived from BaseFileData.
    """
    kwargs['ftype'] = ftype

    if ftype == 'MFSIM6':
        return MfsimData(**kwargs)
    elif ftype == 'TDIS6':
        return TdisData(**kwargs)
    elif ftype == 'IMS6':
        return ImsData(**kwargs)
    elif ftype == 'EMS6':
        return EmsData(**kwargs)

    # Exchanges
    elif ftype == 'GWF6-GWF6':
        return GwfGwfData(**kwargs)
    elif ftype == 'GWF6-GWT6':
        return GwfGwtData(**kwargs)
    elif ftype == 'GWF6-GWE6':
        return GwfGweData(**kwargs)
    elif ftype == 'GWF6-PRT6':
        return GwfPrtData(**kwargs)
    elif ftype == 'GWT6-GWT6':
        return GwtGwtData(**kwargs)
    elif ftype == 'GWE6-GWE6':
        return GweGweData(**kwargs)

    # GWF
    if ftype == 'ATS6':
        return AtsData(**kwargs)
    elif ftype == 'BUY6':
        return BuyData(**kwargs)
    elif ftype == 'CHD6':
        return ChdData(**kwargs)
    elif ftype == 'CSUB6':
        return CsubData(**kwargs)
    elif ftype == 'DIS6':
        return DisData(**kwargs)
    elif ftype == 'DISU6':
        return DisuData(**kwargs)
    elif ftype == 'DISV6':
        return DisvData(**kwargs)
    elif ftype == 'DRN6':
        return DrnData(**kwargs)
    elif ftype == 'EVT6':
        array_based = kwargs.get('array_based')
        if array_based:
            return EvtArrayData(**kwargs)
        else:
            return EvtListData(**kwargs)
    elif ftype == 'GHB6':
        return GhbData(**kwargs)
    elif ftype == 'GNC6':
        return GncData(**kwargs)
    elif ftype == 'GWF6':
        return GwfData(**kwargs)
    elif ftype == 'HFB6':
        return HfbData(**kwargs)
    elif ftype == 'IC6':
        return IcData(**kwargs)
    elif ftype == 'LAK6':
        return LakData(**kwargs)
    elif ftype == 'MAW6':
        return MawData(**kwargs)
    elif ftype == 'MVR6':
        return MvrData(**kwargs)
    elif ftype == 'NPF6':
        return NpfData(**kwargs)
    elif ftype == 'OBS6':
        return ObsData(**kwargs)
    elif ftype == 'OC6':
        return OcData(**kwargs)
    elif ftype == 'POBS6':
        return PestObsData(**kwargs)
    elif ftype == 'RCH6':
        array_based = kwargs.get('array_based')
        if array_based:
            return RchArrayData(**kwargs)
        else:
            return RchListData(**kwargs)
    elif ftype == 'RIV6':
        return RivData(**kwargs)
    elif ftype == 'SFR6':
        return SfrData(**kwargs)
    elif ftype == 'STO6':
        return StoData(**kwargs)
    elif ftype == 'SWI6':
        return SwiData(**kwargs)
    elif ftype == 'TAB6':
        return TabData(**kwargs)
    elif ftype == 'TAS6':
        return TimeArraySeriesData(**kwargs)
    elif ftype == 'TS6':
        return TimeSeriesData(**kwargs)
    elif ftype == 'TVA6':
        return TvaData(**kwargs)
    elif ftype == 'UZF6':
        return UzfData(**kwargs)
    elif ftype == 'VSC6':
        return VscData(**kwargs)
    elif ftype == 'WEL6':
        return WelData(**kwargs)
    elif ftype == 'ZONE6':
        return ZoneData(**kwargs)

    # GWT
    elif ftype == 'ADV6':
        return AdvData(**kwargs)
    elif ftype == 'CNC6':
        return CncData(**kwargs)
    elif ftype == 'DSP6':
        return DspData(**kwargs)
    elif ftype == 'FMI6':
        return FmiData(**kwargs)
    elif ftype == 'GWT6':
        return GwtData(**kwargs)
    elif ftype == 'IST6':
        return IstData(**kwargs)
    elif ftype == 'LKT6':
        return LktData(**kwargs)
    elif ftype == 'MDT6':
        return MdtData(**kwargs)
    elif ftype == 'MST6':
        return MstData(**kwargs)
    elif ftype == 'MVT6':
        return MvtData(**kwargs)
    elif ftype == 'MWT6':
        return MwtData(**kwargs)
    elif ftype == 'SFT6':
        return SftData(**kwargs)
    elif ftype == 'SRC6':
        return SrcData(**kwargs)
    elif ftype == 'SSM6':
        return SsmData(**kwargs)
    elif ftype == 'UZT6':
        return UztData(**kwargs)

    # GWE
    elif ftype == 'CND6':
        return CndData(**kwargs)
    elif ftype == 'CTP6':
        return CtpData(**kwargs)
    elif ftype == 'GWE6':
        return GweData(**kwargs)
    elif ftype == 'ESL6':
        return EslData(**kwargs)
    elif ftype == 'EST6':
        return EstData(**kwargs)
    elif ftype == 'LKE6':
        return LkeData(**kwargs)
    elif ftype == 'MVE6':
        return MveData(**kwargs)
    elif ftype == 'MWE6':
        return MweData(**kwargs)
    elif ftype == 'SFE6':
        return SfeData(**kwargs)
    elif ftype == 'UZE6':
        return UzeData(**kwargs)

    # PRT
    elif ftype == 'PRT6':
        # return PrtData(**kwargs)
        return None
    elif ftype == 'MIP':
        # return MipData(**kwargs)
        return None
    elif ftype == 'PRP':
        # return PrpData(**kwargs)
        return None

    else:
        return None
