"""ExchangeWriterBase class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from typing_extensions import override

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_writer_base import PackageWriterBase
from xms.mf6.misc.settings import Settings


class ExchangeWriterBase(PackageWriterBase):
    """Base class for writing an exchange file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()

    def write_settings(self, data):
        """If writing to components area, save fname to a settings file.

        Args:
            data: The package data.
        """
        super().write_settings(data)
        if self._writer_options.dmi_sim_dir:
            settings = Settings.read_settings(data.filename)
            settings['exgtype'] = data.exgtype
            settings['exgmnamea'] = data.exgmnamea
            settings['exgmnameb'] = data.exgmnameb
            Settings.write_settings(data.filename, settings)

    @override
    def _write_package(self, data):
        """Writes the package.

        Args:
            data: Something derived from BaseFileData
        """
        self._data = data
        with open(self._data.filename, 'w') as fp:
            self._write_comments(fp)
