"""Logging utility functions."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.misc.log_capture_handler import LogCaptureHandler

# Module variables
_log_capture_handler: LogCaptureHandler | None = None


def get_logger() -> logging.Logger:
    """Return the xmsmf6 logger, properly initialized.

    Returns:
        See description.
    """
    logger = logging.getLogger('xms.mf6')

    global _log_capture_handler
    if _log_capture_handler is None:
        _log_capture_handler = LogCaptureHandler()
        logger.addHandler(_log_capture_handler)
    return logger


def clear_log_capture() -> None:
    """Return _log_capture_handler."""
    if _log_capture_handler:
        _log_capture_handler.clear()


def errors_logged() -> bool:
    """Return True if the log shows there were errors.

    Returns:
        See description.
    """
    if _log_capture_handler:
        errors = any(record.levelno == logging.ERROR for record in _log_capture_handler.records)
        return errors
    return False
