"""Base class for tests which use unittest.TestCase."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import unittest

# 2. Third party modules
import pytest

# 3. Aquaveo modules

# 4. Local modules


class BaseTestCase(unittest.TestCase):
    """Base class for tests which use unittest.TestCase."""
    @pytest.fixture(autouse=True)
    def setup_caplog(self, caplog):
        """Inject caplog fixture."""
        self._caplog = caplog
