"""Impoundment data."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel
from xms.tool_core.table_definition import FloatColumnType, StringColumnType, TableDefinition

# 4. Local modules

TIME_INTERVALS = [
    '1Year',
    '1Month',
    'Semi-Month',
    'Tri-Month',
    '1Week',
    '1Day',
    '12Hour',
    '8Hour',
    '6Hour',
    '4Hour',
    '3Hour',
    '2Hour',
    '1Hour',
    '30Minute',
    '20Minute',
    '15Minute',
    '12Minute',
    '10Minute',
    '6Minute',
    '5Minute',
    '4Minute',
    '3Minute',
    '2Minute',
    '1Minute',
    '30Second',
    '20Second',
    '15Second',
    '10Second',
    '6Second',
    '5Second',
    '4Second',
    '3Second',
    '2Second',
    '1Second',
]


class _RuleCurveDataDef:
    """A class to define the impoundment data for the generic model."""
    def __init__(self):
        self.generic_model = GenericModel()
        self._data_def()

    def _data_def(self):
        """Defines the data for the generic model."""
        pp = self.generic_model.material_parameters
        grp = pp.add_group(group_name='default_curve', label='Default curve')
        grp.add_option(name='xunits', label='X Units (<xunits>)', options=TIME_INTERVALS, default='1Day')
        lab = 'Cycle - DSS time interval (<cycle>)'
        grp.add_option(name='cycle', label=lab, options=TIME_INTERVALS, default='1Year')
        grp.add_text(name='yunits', label='Y Units (<yunits>)')
        opts = ['INST-VAL', 'PER-AVER', 'PER-CUM']
        grp.add_option(name='type', label='Type', options=opts, default=opts[0])
        # inputs for SSTable
        cols = [StringColumnType(header='X Values', default=''), FloatColumnType(header='Y Values', default=0.0)]
        td = TableDefinition(cols)
        default_vals = []
        grp.add_table(name='table', label='Rule curve table', table_definition=td, default=default_vals)
        # add monitor to rule curve
        # parent = grp.add_boolean(name='monitor', label='Monitor rule curve (<rcmonitor>)', default=False)
        # par = grp.add_text(name='monitor_label', label='Monitor label (<label>)', default='')
        # par.add_dependency(parent=parent, flags={True: True, False: False})


def generic_model():
    """Gets a generic model for the boundary conditions coverage.

    Returns:
        (xms.gmi.data.generic_model.GenericModel): the generic model class
    """
    dd = _RuleCurveDataDef()
    return dd.generic_model
