"""SMS entry point for the simulation export script."""

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"

# 1. Standard Python modules
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query, XmsEnvironment as XmEnv
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.schism.feedback.export_simulation_runner import ExportSimulationRunner


def main(query: Optional[Query] = None):
    """Entry point wrapper."""
    try:
        worker = ExportSimulationRunner(query)
        run_feedback_dialog(worker)
    except Exception as ex:  # pragma: no cover
        XmEnv.report_error(ex, 'c:/temp/log.txt')


if __name__ == "__main__":  # pragma: no cover
    main()
