"""SMS entry point for the simulation import script."""

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"

# 1. Standard Python modules
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query, XmsEnvironment as XmEnv
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.schism.feedback.import_simulation_runner import ImportSimulationRunner


def main(query: Optional[Query] = None):
    """Entry point wrapper."""
    try:
        worker = ImportSimulationRunner(query)
        run_feedback_dialog(worker)
    except Exception as ex:  # pragma: nocover
        XmEnv.report_error(ex)  # The feedback thread handles everything by logging it, so this should be unreachable.


if __name__ == "__main__":  # pragma: no cover
    main()
