"""Module for the model run entry point."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import ast
import subprocess

# 2. Third party modules

# 3. Aquaveo modules
from xms.core.filesystem.filesystem import make_or_clear_dir

# 4. Local modules

if __name__ == '__main__':
    make_or_clear_dir('outputs')

    with open('xms_params.txt') as f:
        content = f.read()

    params = ast.literal_eval(content)
    schism = params['schism']
    mpi = params['mpi']
    processes = params['processes']

    subprocess.run([mpi, '-n', str(processes), schism])
