"""Module for Boundary class."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass
from typing import Sequence

# 2. Third party modules

# 3. Aquaveo modules
from xms.constraint import UGrid2d

# 4. Local modules


@dataclass
class Boundary:
    """
    Data class representing a boundary.

    Args:
        boundary_type: The boundary's type.
        nodes: IDs of nodes on the boundary.
    """
    boundary_type: int
    nodes: Sequence[int]


@dataclass
class Fort14File:
    """
    Class representing the content of a fort.14 file.

    Args:
        ugrid: The domain geometry.
        dataset: The "elevation" values of the domain. This is mainly for SCHISM, which stores datasets by writing a
            copy of the domain where elevation values are replaced by whatever data is being stored (temperature, for
            example). When reading, this will be redundant with the domain and can be discarded if you only need that.
            If present when writing, elevation values for the output will be taken from the dataset rather than the
            ugrid.
        open_boundaries: Open boundaries to write into the file.
        closed_boundaries: Closed boundaries to write into the file.
    """
    ugrid: UGrid2d = None
    dataset: Sequence[float] = None
    open_boundaries: Sequence[Boundary] = None
    closed_boundaries: Sequence[Boundary] = None
