"""Utility functions for XMS."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"


def tool_is_running_from_xms(tool):
    """Check if the tool is running from XMS.

    Args:
        tool (xms.tool_core.Tool): The tool.

    Returns:
        (bool): True if running from XMS.
    """
    dh = tool._data_handler
    return _tool_is_running_from_xms(dh.__module__, dh.__class__.__name__)


def _tool_is_running_from_xms(module_name, class_name):
    """Check if the tool is running from XMS.

    Args:
        module_name (str): The module name.
        class_name (str): The class name.

    Returns:
        (bool): True if running from XMS.
    """
    if module_name == 'xms.tool_gui.xms_data_handler' and class_name == 'XmsDataHandler':
        return True
    return False
