"""ugrid_from_disu module."""

__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard python modules
import sys

# 2. Third party modules

# 3. Aquaveo modules
from xms.mf6.data.base_file_data import BaseFileData
from xms.mf6.geom.ugrid_builder import UGridBuilder

# 4. Local modules


def main():
    """Runs the script."""
    # from xms.guipy import debug_pause
    # debug_pause()
    args = sys.argv[1:]
    disu_filename = args[0]
    output_filename = args[1]
    with open(output_filename, 'w') as file:
        try:
            disu = BaseFileData.from_file(disu_filename, 'DISU6')
            if 'VERTICES' not in disu.list_blocks or 'CELL2D' not in disu.list_blocks:
                raise RuntimeError('VERTICES and CELL2D blocks required to read .disu file.')
            builder = UGridBuilder()
            dogrid, _cogrid = builder.build_dis_grid(disu)
            file.write(f'{dogrid.cogrid_file}\n')
        except Exception as ex:
            file.write(str(ex))


if __name__ == "__main__":  # pragma no cover - can't run this from the tests and it must be here
    main()
