"""Classes to provide data for the project explorer."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class TreeData:
    """Data class to hold data specific to the tree items for the data."""

    def __init__(self, icon=None, is_checked=False, is_expanded=False, is_selected=False, parent_uuid=None):
        """Initialize the select_dlg class.

        Args:
            icon (string): The icon for the item
            is_checked (bool): True if the item is is_checked
            is_selected (bool): True if the item is is_selected
            is_expanded (bool): True if the item is is_expanded
            parent_uuid (uuid): The uuid of the parent of the item
        """
        self.icon = icon
        self.is_checked = is_checked
        self.is_expanded = is_expanded
        self.is_selected = is_selected
        self.is_editing = False
        self.is_drag_enabled = True
        self.is_drop_enabled = False
        self.is_read_only = False

        self.parent_uuid = parent_uuid
