"""CalcData for performing Contraction Scour calculations."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.HydraulicToolboxCalc.hydraulics.bridge_scour.scenario.scour_base_calc import ScourBaseCalc


class LongTermDegradationCalc(ScourBaseCalc):
    """A class that defines the long-term degradation at a bridge contraction."""

    def _get_can_compute(self):
        """Determines if there is enough data to make a computation and if there isn't, add a warning for each reason.

        Args:
            unknown (string): variable that is unknown and being calculated.

        Returns:
            bool: True if can compute
        """
        result = True

        if self.input_dict['calc_data']['Calculation method'] == 'Specify LTD depth':
            result = self.check_float_vars_to_greater_zero(['Specified depth of long-term degradation'])
        # else:
        #     if self.gradations:
        #         if len(self.approach_gradation_dict) <= 0:
        #             self.update_gradation_lists()
        #     else:
        #         # Update D50s for gradation or user-specified
        #         # self.upstream_d50 and self.d50 are updated in the get_input_group step
        #         self.results['Approach D50'] = self.upstream_d50
        #         self.results['Contracted D50'] = self.d50

        #     # Convert the D50s to ft
        #     _, self.upstream_d50 = self.unit_converter.convert_units(
        #         'mm', 'ft', self.input_dict['calc_data']['Approach D50'])
        #     _, self.d50 = self.unit_converter.convert_units(
        #         'mm', 'ft', self.input_dict['calc_data']['Contracted D50'])

        return result

    def _compute_data(self):
        """Computes the data possible; stores results in self.

        Returns:
            bool: True if successful
        """
        # Document the source of the equation (if possible):
        #   Give publication, date, page number and link (if there's a bug, that it can be traced back to the source).
        # Assign new variables from the input_dict in similar names as the equation and document units

        self.scour_depth = 0.0

        if self.input_dict['calc_data']['Calculation method'] == 'Specify LTD depth':
            self.scour_depth = self.input_dict['calc_data']['Specified depth of long-term degradation']
            if 'Results' not in self.results:
                self.results['Results'] = {}
            self.results['Results']['Long-term degradation'] = self.scour_depth

        self.compute_scour_hole_geometry()
        return True
