"""Worker thread for the fort.22 exporter."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.dialogs.process_feedback_dlg import ProcessFeedbackThread

# 4. Local modules
from xms.adcirc.dmi.fort22_data_getter import Fort22DataGetter
from xms.adcirc.feedback.xmlog import XmLog
from xms.adcirc.file_io.fort22_writer import Fort22Writer


class Fort22ExportWorkerThread(ProcessFeedbackThread):
    """Worker thread for exporting an ADCIRC fort.22 file."""
    def __init__(self, filename, query, parent):
        """Construct the worker.

        Args:
            filename (:obj:`str`): Path to the export location.
            query (:obj:`xms.api.dmi.Query`): Object for communicating with XMS
            parent (:obj:`QWidget`): Parent of the QThread
        """
        super().__init__(parent=parent, do_work=self._do_work)
        self.filename = filename
        self.query = query

    def _do_work(self):
        """Thread runner that exports the fort.22."""
        XmLog().instance.info('Exporting ADCIRC wind data...')
        try:
            xms_data = {}
            getter = Fort22DataGetter(self.query, xms_data)
            getter.retrieve_data()
            writer = Fort22Writer(self.filename, False, xms_data)
            writer.write()
        except Exception:
            XmLog().instance.exception('Error! Could not export ADCIRC wind data.')
