"""Entry point to export fort.13 file in parallel with the fort.15."""

# 1. Standard Python modules
import argparse

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 4. Local modules
from xms.adcirc.feedback.xmlog import XmLog
from xms.adcirc.file_io.fort13_writer import export_nodal_atts_for_sim


def main():
    """Entry point wrapper."""
    arguments = argparse.ArgumentParser(description="Entry point to export fort.13 in parallel with fort.15")
    arguments.add_argument(dest='out_file', type=str, help='absolute path to fort.13 file to be exported')
    parsed_args = arguments.parse_args()
    try:
        XmLog.echo_output = True
        export_nodal_atts_for_sim(parsed_args.out_file.strip("'\""))
    except Exception as ex:
        msg = 'Error(s) encountered while exporting ADCIRC nodal attributes.'
        XmLog().instance.exception(msg)
        XmEnv.report_error(msg)
        XmEnv.report_error(ex)


if __name__ == '__main__':
    main()
