"""A dialog for assigning friction card values."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import webbrowser

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.dialogs.xms_parent_dlg import XmsDlg

# 4. Local modules
from xms.adh.gui.friction_dialog_ui import Ui_FrictionDialog
from xms.adh.gui.widgets.friction_widget import FrictionWidget


class FrictionDialog(XmsDlg):
    """A dialog for assigning friction to arcs."""
    def __init__(self, win_cont, title):
        """Allows the user to edit arc friction.

        Args:
            win_cont (QWidget): Parent window
            title (str): Window title
        """
        super().__init__(win_cont, 'xms.adh.gui.friction_dialog')
        self.ui = Ui_FrictionDialog()
        self.ui.setupUi(self)
        self.friction = FrictionWidget(self, True)
        self.help_url = 'https://www.xmswiki.com/wiki/SMS:ADH_Material_Properties'

        self.setWindowTitle(title)
        self._setup()

    def _setup(self):
        self.ui.main_layout.insertWidget(0, self.friction)
        # QDialogButtonBox with Ok and Cancel buttons
        self.ui.button_box.helpRequested.connect(self.help_requested)
        self.adjustSize()
        self.resize(self.size().width() * 1.5, self.size().height())

        # set all widget values and hide/show
        # self.param_helper.do_param_widgets(None)

    def help_requested(self):
        """Called when the Help button is clicked."""
        webbrowser.open(self.help_url)

    def accept(self):
        """Called when the Ok button is clicked."""
        return super().accept()

    def reject(self):
        """Called when the Cancel button is clicked."""
        return super().reject()
