"""This module checks for data errors in the simulation."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query

# 4. Local modules
from xms.cmsflow.dmi._cmsflow_model_check import CMSFlowModelChecker
from xms.cmsflow.dmi.xms_data import XmsData


def main():
    """Entry point for the CMS-Flow model check script."""
    query = Query()
    data = XmsData(query)
    checker = CMSFlowModelChecker(data)
    checker.run_checks()
    query.send()


if __name__ == "__main__":
    main()
