from .._xmsconstraint.quadtree import refinement
from xms.constraint.quadtree.quad_grid_cells import QuadGridCells


def refine_quadtree_gridcells(input_grid,
                              mapper_points=None,
                              mapper_arcs=None,
                              mapper_polygons=None):
    """Function to take a quadtree and refine it based on polygon points and arcs.
    
    Args:
        input_grid: The input grid to modify.
        mapper_point: list of mapper points with refinement info.
        mapper_arcs: list of mapper arcs with refinment info.
        mapper_polygons: list of mapper polygons with refinement info.

    Returns:
        Quadgrid cells for the newly refined quadtree.
    """
    if mapper_points == None:
        mapper_points = []
    if mapper_arcs is None:
        mapper_arcs = []
    if mapper_polygons is None:
        mapper_polygons = []

    point_instances = [p._instance for p in mapper_points]
    arc_instances = [a._instance for a in mapper_arcs]
    polygon_instances = [p._instance for p in mapper_polygons]

    new_quad_grid_cells, cell_map = refinement.qtAddRefinement(
        input_grid._instance, point_instances, arc_instances,
        polygon_instances)
    return QuadGridCells(instance=new_quad_grid_cells), cell_map
