from . import GridType
from . import _xmsconstraint
from .rectilinear_data import RectilinearData
from .rectilinear_grid_2d import RectilinearGrid2d
from .rectilinear_grid_3d import RectilinearGrid3d


class RectilinearGridBuilder(RectilinearData):
    """Builder for a rectilinear constrained UGrid."""

    def __init__(self):
        instance = _xmsconstraint.constraint.CoRectilinearGridBuilder()
        RectilinearData.__init__(self, instance)

    def build_grid(self):
        """Build the specified grid.
        Returns:
            The rectilinear constrained UGrid.
        """
        grid = self._instance.BuildGrid()
        if grid.GetGridType() == GridType.rectilinear_2d:
            return RectilinearGrid2d(grid)
        elif grid.GetGridType() == GridType.rectilinear_3d:
            return RectilinearGrid3d(grid)
        raise ValueError('Unable to build rectilinear grid.')
