"""Python wrapping for xms._data_objects.parameters.Point."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.data_objects._data_objects.parameters import Point as CPoint


class Point:
    """The pure Python wrapper for C++ exposed xms._data_objects.parameters.Point objects."""
    def __init__(self, x=0.0, y=0.0, z=0.0, feature_id=None, instance=None):
        """Construct the wrapper.

        Args:
            x (float): Point's x coordinate
            y (float): Point's y coordinate
            z (float): Point's z coordinate
            feature_id (int): Point's XMS feature id
            instance (CPoint): C++ Point object to wrap
        """
        if instance is None:
            instance = CPoint(x, y, z)
        self._instance = instance

        if feature_id is not None:
            self._instance.SetId(feature_id)

    @property
    def id(self):
        """Returns the point's XMS feature id."""
        return self._instance.GetId()

    @id.setter
    def id(self, point_id):
        """Sets the point's XMS feature id.

        Args:
            point_id (int): Id to assign the point
        """
        self._instance.SetId(point_id)

    @property
    def x(self):
        """Returns the point's x-coordinate."""
        return self._instance.GetX()

    @x.setter
    def x(self, x_coord):
        """Sets the point's x-coordinate.

        Args:
            x_coord (float): The point's x-coordinate
        """
        self._instance.SetX(x_coord)

    @property
    def y(self):
        """Returns the point's y-coordinate."""
        return self._instance.GetY()

    @y.setter
    def y(self, y_coord):
        """Sets the point's y-coordinate.

        Args:
            y_coord (float): The point's y-coordinate
        """
        self._instance.SetY(y_coord)

    @property
    def z(self):
        """Returns the point's z-coordinate."""
        return self._instance.GetZ()

    @z.setter
    def z(self, z_coord):
        """Sets the point's z-coordinate.

        Args:
            z_coord (float): The point's z-coordinate
        """
        self._instance.SetZ(z_coord)
