"""Reads the .ihl IN_HYD_LOCATION file which contains hydrograph output locations.
"""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def read(file_path: Path, output_hydrograph_links: list[int]) -> None:
    """Reads the .ihl IN_HYD_LOCATION file which contains hydrograph output locations.

    Args:
        file_path: .ihl file path.
        output_hydrograph_links: Data about the streams.
    """
    with open(file_path, 'r') as file:
        line = next(file)
        line = line.rstrip('\n')
        n = int(line)
        for _ in range(n):
            line = next(file)
            line = line.rstrip('\n')
            link = int(line.split()[0])
            output_hydrograph_links.append(link)
