"""Model to rename header titles."""

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import QSortFilterProxyModel, Qt

# 3. Aquaveo modules

# 4. Local modules


class RenameModel(QSortFilterProxyModel):
    """A model to rename header titles."""
    def __init__(self, column_names, parent=None):
        """Initializes the filter model.

        Args:
            column_names (list): The column names.
            parent (Something derived from QObject): The parent object.

        """
        self.column_names = column_names
        super().__init__(parent)

    def headerData(self, section, orientation, role=Qt.DisplayRole):  # noqa: N802
        """Returns the data for the given role and section in the header.

        Args:
            section (int): The section.
            orientation (Qt.Orientation): The orientation.
            role (int): The role.

        Returns:
            The data.
        """
        if role != Qt.DisplayRole:
            return super().headerData(section, orientation, role)

        if orientation == Qt.Horizontal:
            return self.column_names[section]
        else:
            return super().headerData(section, orientation, role)
