"""Utilities for tests."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from contextlib import contextmanager
import os
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def git_clean(path: Path) -> None:
    """Remove all unversioned files.

    Args:
        path (Path): Path to clean unversioned files from.
    """
    with working_directory(path):
        os.system('git clean -f -d')


@contextmanager
def working_directory(path: Path):
    """Changes working directory and returns to previous on exit.

    See https://stackoverflow.com/questions/431684.

    Args:
        path (Path): Path to temporarily change the working directory to.
    """
    prev_cwd = Path.cwd()
    os.chdir(path)
    try:
        yield
    finally:
        os.chdir(prev_cwd)


# def debug_file_write(s: str) -> None:
#     """Appends the string to C:/temp/debug_hgs.txt."""
#     with open('C:/temp/debug_hgs.txt', 'a') as file:
#         file.write(f'{s}\n')
