"""sim_exporter module."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment

# 4. Local modules
from xms.hgs.file_io.hgs_exporter import HgsExporter


def main():
    """Runs the script."""
    try:
        testing = XmsEnvironment.xms_environ_running_tests() == 'TRUE'
        HgsExporter.run_script(feedback=True, testing=testing)
    except Exception as ex:
        XmsEnvironment.report_error(ex)


if __name__ == "__main__":  # pragma no cover - can't run this from the tests and it must be here
    main()
