"""Time-Array-Series file."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.gwf.array_package_data import ArrayPackageData


class TimeArraySeriesData(ArrayPackageData):
    """Data class to hold the info from a TAS6 time series file."""
    def __init__(self, **kwargs):
        """Initializes the class.

        Args:
            **kwargs: Arbitrary keyword arguments.

        Keyword Args:
            ftype (str): The file type used in the GWF name file (e.g. 'WEL6')
            mfsim (MfsimData): The simulation.
            model (GwfData or GwtData): The GWF/GWT model. Will be None for TDIS, IMS, Exchanges (things below mfsim)
            grid_info (GridInfo): Information about the grid. Only used when testing individual packages. Otherwise,
             it comes from model and dis.
        """
        super().__init__(**kwargs)
        self.ftype = 'TAS6'

    def dialog_title(self):
        """Returns the title to show in the dialog.

        You should override this method.

        Returns:
            (str): The dialog title.
        """
        return ''

    def is_layer_indicator(self, array_name) -> bool:
        """Returns True if the array is a layer indicator ('IEVT', 'IRCH').

        Returns:
            (bool): True or False
        """
        return False

    def array_supports_time_array_series(self, array_name) -> bool:
        """Returns True if the array can have time-array series.

        Returns:
            (bool): True or False
        """
        return False
