"""ExchangeReaderBase class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os

# 2. Third party modules
from typing_extensions import override

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_reader import PackageReader
from xms.mf6.misc.settings import Settings


class ExchangeReaderBase(PackageReader):
    """Base class for reading an exchange file."""
    def __init__(self, ftype):
        """Initializes the class."""
        super().__init__(ftype)
        self._block_methods = {'EXCHANGEDATA': '_handle_list_block'}

    @override
    def read_settings(self) -> None:
        """Reads the package settings file if it exists."""
        super().read_settings()
        if os.path.exists(Settings.settings_filename(self._data.filename)):
            settings = Settings.read_settings(self._data.filename)
            exgtype = settings.get('exgtype', '')
            exgmnamea = settings.get('exgmnamea', '')
            exgmnameb = settings.get('exgmnameb', '')
            if exgtype:
                self._data.exgtype = exgtype
            if exgmnamea:
                self._data.exgmnamea = exgmnamea
            if exgmnameb:
                self._data.exgmnameb = exgmnameb
