"""ZoneReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_reader import PackageReader


class ZoneReader(PackageReader):
    """Reads the package."""
    def __init__(self):
        """Initializes the class."""
        super().__init__('ZONE6')
        self._stop_after_block = 'GRIDDATA'

    def _read_dimensions(self, line):
        """Reads the dimensions block.

        Args:
            line (str): A line from the file.
        """
        words = line.split()
        if words and words[0] == 'NCELLS' and len(words) > 1:
            self._data.ncells = int(words[1])
