"""Pest obs util."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field

# 2. Third party modules

# 3. Aquaveo modules
from xms.data_objects.parameters import Coverage

# 4. Local modules

# Types and type aliases


@dataclass
class CovInfo:
    """Coverage path and att files."""
    tree_path: str = ''  # Tree path
    att_files: list[str] = field(default_factory=list)  # Att file filepaths


ObsCovData = dict[Coverage, CovInfo]
"""Observation coverages and their info."""

# B2Map = dict[str: dict[str: str, str: str, str: float, str: ?, str: str]]


def cov_name_from_path(cov_tree_path: str) -> str:
    """Return the coverage name given the tree path.

    Args:
        cov_tree_path: Tree path of coverage.

    Returns:
        See description.
    """
    if not cov_tree_path:
        return ''
    last_slash_pos = cov_tree_path.rfind('/')
    return cov_tree_path[last_slash_pos + 1:]
