"""Module for the PtmTrapsComponent."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['PtmTrapsComponent']

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.component_bases.coverage_component_base import CoverageComponentBase
from xms.gmi.data.generic_model import Section
from xms.guipy.data.target_type import TargetType

# 4. Local modules
from xms.ptm.model.model import trap_model


class PtmTrapsComponent(CoverageComponentBase):
    """Component for the Traps coverage."""
    def _get_section(self, target: TargetType) -> Section:
        return trap_model().section_from_target_type(target)
