"""Module for VGridFile class."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class VGridFile:
    """
    Class representing the content of a vgrid.in file.

    Args:
        hc: int
        theta_b: float
        theta_f: float
        z_levels: list[float]
        s_levels: list[float]
    """
    hc: float = 0
    theta_b: float = 0.0
    theta_f: float = 0.0
    z_levels: list[float] = None
    s_levels: list[float] = None
