"""Point class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import collections

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class Point(collections.UserList):
    """Class to represent a 2D XY point using list syntax or .x, .y syntax."""
    def __init__(self, x=None, y=None):
        """Initializes the class.

        Args:
            x: The point X coordinate, OR a list with the x and y values
            y: The point Y coordinate.
        """
        if (x and type(x) in [list, tuple] and y) or (y and type(y) in [list, tuple]):  # pragma: no cover
            raise RuntimeError('Point initialized with list and other data.')
        elif x and type(x) in [list, tuple]:
            super().__init__(x)
            while len(self.data) < 2:  # Make sure we have at least 2 values
                self.data.append(0.0)
        else:
            x = 0.0 if x is None else x
            y = 0.0 if y is None else y
            super().__init__([x, y])

    @property
    def x(self):
        """Returns the X coordinate.

        Returns:
            See description.
        """
        return self.data[0]

    @x.setter
    def x(self, value):
        """Sets the X coordinate.

        Args:
            value: The X coordinate.
        """
        self.data[0] = value

    @property
    def y(self):
        """Returns the Y coordinate.

        Returns:
            See description.
        """
        return self.data[1]

    @y.setter
    def y(self, value):
        """Sets the Y coordinate.

        Args:
            value: The Y coordinate.
        """
        self.data[1] = value
