"""Script to launch to the version of SRH."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

if __name__ == '__main__':
    import argparse
    import os
    from srh2d_exe import get_executable_paths
    import sys
    from xms.api.dmi import XmsEnvironment as XmEnv

    parser = argparse.ArgumentParser(description="SRH Version Check.")
    parser.add_argument(
        '-rp',
        '--remove_paths',
        help='Option to remove path from the printed executable file names',
        required=False,
        default=False
    )
    args = parser.parse_args()

    exe_list = get_executable_paths()
    pre_exe = ''
    srh_exe = ''
    for item in exe_list:
        ii = item.lower()
        if ii.endswith('srh_pre_console.exe'):
            pre_exe = item
            if args.remove_paths:
                pre_exe = os.path.basename(pre_exe)
        elif ii.endswith('srh-2d_console_v362.exe') or ii.endswith('srh-2d_console.exe'):
            srh_exe = item
            if args.remove_paths:
                srh_exe = os.path.basename(srh_exe)

    err_msg = f'ERROR!\n\nWrong version of SRH found. Expecting version 3.6.5.\n' \
              f'Change the version of SRH by selecting the Edit | Preferences command in SMS. ' \
              f'Then switch to the "File Locations" tab and change the PreSRH-2D and SRH-2D files in ' \
              f'the "Model Executables" section.\n\n' \
              f'PreSRH-2D:\n {pre_exe}\n\n' \
              f'SRH-2D:\n {srh_exe}\n\n'
    print(err_msg)
    log_file = XmEnv.xms_environ_stdout_file()
    with open(log_file, 'a') as out:
        out.write(err_msg)
    sys.exit(1)
