"""LinearInterpolateToUGridTool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from typing import List

# 2. Third party modules

# 3. Aquaveo modules
from xms.tool_core import Argument

# 4. Local modules
from xms.tool.datasets import interpolate_to_ugrid as itu


class LinearInterpolateToUGridTool(itu.InterpolateToUGridTool):
    """Tool to interpolate from a ugrid to another ugrid."""

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.name = 'Linear Interpolation to UGrid'

    def initial_arguments(self):
        """Get initial arguments for tool.

        Must override.

        Returns:
            (list): A list of the initial tool arguments.
        """
        arguments = super().initial_arguments()
        arguments[itu.ARG_INPUT_INTERP_METHOD].value = 'Linear'
        self.enable_arguments(arguments)
        return arguments

    def enable_arguments(self, arguments: List[Argument]):
        """Called to show/hide arguments, change argument values and add new arguments.

        Args:
            arguments(list): The tool arguments.
        """
        super().enable_arguments(arguments)
        arguments[itu.ARG_INPUT_INTERP_METHOD].show = False
        arguments[itu.ARG_INPUT_LINEAR_CLOUGH_TOCHER].show = False
        arguments[itu.ARG_INPUT_ANISOTROPY].show = False
        arguments[itu.ARG_INPUT_LOG].show = False
