"""xmscomponents entry points for XMS."""
# 1. Standard Python modules
import argparse
import sys

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.tool_gui.runners import tool_runner


def main(args):
    """The main routine."""
    arguments = argparse.ArgumentParser(description="Toolbox.")
    arguments.add_argument(dest='script', type=str, help='script to run')
    arguments.add_argument(dest='vars', nargs='*', help='other arguments')
    parsed_args = arguments.parse_args(args)
    if parsed_args.script == 'run_tool':
        tool_runner.main(args)


if __name__ == "__main__":  # pragma no cover - more confusing to call from test than to pragma
    main(sys.argv[1:])
