"""Qt table view for entering layer face Z values."""
# 1. Standard python modules

# 2. Third party modules
from PySide2.QtGui import QDoubleValidator
from PySide2.QtWidgets import QAbstractItemView

# 3. Aquaveo modules
from xms.guipy.delegates.edit_field_validator import EditFieldValidator
from xms.guipy.validators.number_corrector import NumberCorrector

# 4. Local modules
from xms.tuflowfv.gui.tuflowfv_table import TuflowfvTableWidget


class LayerFacesTableWidget(TuflowfvTableWidget):
    """The layer faces table widget."""

    def __init__(self, data_frame, parent=None):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (pandas.DataFrame): The model data.
        """
        super().__init__(parent=parent, data_frame=data_frame, select_col=0, default_values={'Z': 0.0})
        self.setup_ui()

    def setup_ui(self):
        """Add the table widget and initialize the model."""
        dbl_validator = QDoubleValidator(self)
        dbl_validator.setDecimals(NumberCorrector.DEFAULT_PRECISION)
        dbl_delegate = EditFieldValidator(dbl_validator, self)
        delegates = {0: dbl_delegate}
        super()._setup_ui(delegates, False, False)
        self.table_view.setEditTriggers(
            QAbstractItemView.DoubleClicked | QAbstractItemView.EditKeyPressed | QAbstractItemView.AnyKeyPressed
        )
        self.table_view.verticalHeader().setVisible(False)
