"""SimData class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel, Section
from xms.gmi.data_bases.sim_base_data import SimBaseData

# 4. Local modules
from xms.wavewatch3.data.model import get_model
from xms.wavewatch3.data.output_fields import get_output_field_model


class SimData(SimBaseData):
    """Manages data for the simulation component."""
    @property
    def model_control_data(self) -> Section:
        """Generic model section with the model control parameters."""
        section = get_model().global_parameters
        vals = self.global_values
        if vals:
            section.restore_values(vals)
        return section

    @property
    def output_fields_data(self) -> Section:
        """Generic model section with the output field parameters."""
        section = get_output_field_model().model_parameters
        vals = self.output_field_values
        if vals:
            section.restore_values(vals)
        return section

    @property
    def output_field_values(self) -> str:
        """Values for output field parameters."""
        if 'OUTPUT_FIELD_VALUES' in self.info.attrs:
            return self.info.attrs['OUTPUT_FIELD_VALUES']
        else:  # Let GenericModel define the default ones so it can change them later if necessary.
            return GenericModel().model_parameters.extract_values()

    @output_field_values.setter
    def output_field_values(self, value: str):
        """Values for output field parameters."""
        self.info.attrs['OUTPUT_FIELD_VALUES'] = value
